/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.useobjects.MouseEventDataConverter;
import net.useobjects.Window2D;
import net.useobjects.mouse.MouseChangedEvent;
import net.useobjects.mouse.MouseChangedEventSource;
import net.useobjects.mouse.MouseChangedListener;

class MouseEventConventer
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private MouseChangedEventSource newMouseEventSource;
    private List<MouseChangedListener> listeners;

    public MouseEventConventer(Window2D window, MouseChangedEventSource newMouseEventSource) {
        this.newMouseEventSource = newMouseEventSource;
        this.listeners = new ArrayList<MouseChangedListener>();
        window.addMouseListener(this);
        window.addMouseMotionListener(this);
        window.addMouseWheelListener(this);
    }

    public void addMouseChangedListener(MouseChangedListener listener) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.listeners.add(listener);
        }
    }

    public void removeMouseChangedListener(MouseChangedListener listener) {
        this.listeners.remove(listener);
    }

    private MouseChangedEvent createMouseChangedEvent(MouseChangedEventSource newSource, MouseEvent event) {
        return new MouseChangedEvent(newSource, MouseEventDataConverter.convertStandardMouseEventType(event.getID()), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), MouseEventDataConverter.convertStandardButtonCode(event.getButton()), 0, event.getWhen());
    }

    private MouseChangedEvent createMouseChangedEvent(MouseChangedEventSource newSource, MouseWheelEvent event) {
        return new MouseChangedEvent(newSource, MouseEventDataConverter.convertStandardMouseEventType(event.getID()), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), MouseEventDataConverter.convertStandardButtonCode(event.getButton()), event.getWheelRotation(), event.getWhen());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseClicked(newEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMousePressed(newEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseReleased(newEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseEntered(newEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseExited(newEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseDragged(newEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseMoved(newEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        MouseChangedEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseWheelMoved(newEvent);
        }
    }
}

