/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.keyboard;

import java.util.Arrays;
import java.util.Set;

public class MultiKeyEvent {
    private int[] keyCodes;

    public MultiKeyEvent(Set<Integer> keyCodeSet) {
        this(MultiKeyEvent.setToArray(keyCodeSet));
    }

    public MultiKeyEvent(int[] keyCodes) {
        this.keyCodes = Arrays.copyOf(keyCodes, keyCodes.length);
    }

    private static int[] setToArray(Set<Integer> keyCodeSet) {
        int[] array = new int[keyCodeSet.size()];
        int index = 0;
        for (Integer key : keyCodeSet) {
            array[index] = key;
            ++index;
        }
        return array;
    }

    public int[] getKeyCodes() {
        return Arrays.copyOf(this.keyCodes, this.keyCodes.length);
    }

    public boolean contains(int keyCode) {
        for (int key : this.keyCodes) {
            if (key != keyCode) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.getKeyCodes());
    }
}

