/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.frame.AttributeMousePositionLabel;
import net.useobjects.frame.AttributeSizeLabel;
import net.useobjects.geom.Position;
import net.useobjects.keyboard.Keyboard;
import net.useobjects.keyboard.KeyboardForGame;
import net.useobjects.keyboard.MultiKeyListener;
import net.useobjects.mouse.MouseButton;
import net.useobjects.mouse.MouseChangedListener;
import net.useobjects.mouse.MouseEventDrawableSource;
import net.useobjects.sync.RunnableWithResult;
import net.useobjects.sync.SyncGui;
import net.useobjects.window.Window2D;
import net.useobjects.window.World2DModel;

public class MainWindow {
    private JFrame frame;
    private World2DModel model;
    private Window2D window;
    private Keyboard keyboard;
    private KeyboardForGame keyboardMultiKey;

    public MainWindow(String title) {
        this(title, 0, 0);
    }

    public MainWindow(final String title, final int width, final int height) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.frame = new JFrame(title);
                MainWindow.this.frame.setDefaultCloseOperation(3);
                MainWindow.this.frame.setResizable(false);
                MainWindow.this.model = new World2DModel(width, height);
                MainWindow.this.window = new Window2D(MainWindow.this.model);
                MainWindow.this.frame.setLayout(new BorderLayout());
                MainWindow.this.frame.add((Component)MainWindow.this.window, "Center");
                JPanel statusPanel = new JPanel(new FlowLayout(0, 0, 0));
                MainWindow.this.frame.add((Component)statusPanel, "South");
                AttributeSizeLabel sizeLabel = new AttributeSizeLabel("size");
                MainWindow.this.window.addComponentListener(sizeLabel);
                statusPanel.add(sizeLabel);
                AttributeMousePositionLabel positionLabel = new AttributeMousePositionLabel("position");
                MainWindow.this.window.addMouseListener(positionLabel);
                MainWindow.this.window.addMouseMotionListener(positionLabel);
                statusPanel.add(positionLabel);
                MainWindow.this.keyboard = new Keyboard(MainWindow.this.frame);
                MainWindow.this.keyboardMultiKey = new KeyboardForGame(MainWindow.this.frame);
                MainWindow.this.frame.pack();
            }
        });
    }

    public void setVisible(final boolean b) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.frame.setVisible(b);
            }
        });
    }

    public void add(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.model.add(drawable);
                if (drawable instanceof MouseEventDrawableSource) {
                    MouseEventDrawableSource source = (MouseEventDrawableSource)((Object)drawable);
                    source.setMouseManager(MainWindow.this.window.getMouseManager());
                }
            }
        });
    }

    public void remove(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.model.remove(drawable);
                if (drawable instanceof MouseEventDrawableSource) {
                    MouseEventDrawableSource source = (MouseEventDrawableSource)((Object)drawable);
                    source.setMouseManager(null);
                }
            }
        });
    }

    public Window2D getDrawableSubwindow() {
        return this.window;
    }

    public GroupView getRootGroup() {
        return SyncGui.invokeAndWait(new RunnableWithResult<GroupView>(){

            @Override
            public GroupView runAndReturnResult() {
                return MainWindow.this.model.getRootGroup();
            }
        });
    }

    public void dispose() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.frame.dispose();
            }
        });
    }

    public int getInternalWidth() {
        return this.model.getWidth();
    }

    public int getInternalHeight() {
        return this.model.getHeight();
    }

    public void setBackground(Color color) {
        this.window.setBackground(color);
    }

    public boolean isKeyDown(int keyCode) {
        return this.keyboard.isKeyDown(keyCode);
    }

    public boolean isMouseButtonDown(MouseButton mouseButton) {
        return this.window.isMouseButtonDown(mouseButton);
    }

    public Position getMousePosition() {
        return this.window.getActualMousePosition();
    }

    public void addMultiKeyListener(MultiKeyListener listener) {
        this.keyboardMultiKey.addMultiKeyListener(listener);
    }

    public void removeMultiKeyListener(MultiKeyListener listener) {
        this.keyboardMultiKey.removeMultiKeyListener(listener);
    }

    public void addMouseChangedListener(MouseChangedListener listener) {
        this.window.addMouseChangedListener(listener);
    }

    public void removeMouseChangedListener(MouseChangedListener listener) {
        this.window.removeMouseChangedListener(listener);
    }
}

