/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.geom.Position;
import net.useobjects.sync.SyncGui;

abstract class AbstractDrawableMovableObject
extends AbstractDrawableObject {
    private Position position;

    public AbstractDrawableMovableObject(double positionX, double positionY) {
        this.position = new Position(positionX, positionY);
    }

    public AbstractDrawableMovableObject(Position position) {
        this(position.getX(), position.getY());
    }

    @Override
    public void draw(Graphics2D g2d) {
        g2d.translate(this.getPositionX(), this.getPositionY());
    }

    public void setPosition(final double x, final double y) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractDrawableMovableObject.this.position.set(x, y);
                AbstractDrawableMovableObject.this.fireChanged();
            }
        });
    }

    public void setPosition(Position position) {
        this.setPosition(position.getX(), position.getY());
    }

    public void setPositionX(double x) {
        this.setPosition(x, this.getPositionY());
    }

    public void setPositionY(double y) {
        this.setPosition(this.getPositionX(), y);
    }

    public Position getPosition() {
        return new Position(this.position);
    }

    public double getPositionX() {
        return this.position.getX();
    }

    public double getPositionY() {
        return this.position.getY();
    }

    public int getRoundedPositionX() {
        return this.position.getRoundedX();
    }

    public int getRoundedPositionY() {
        return this.position.getRoundedY();
    }

    public void move(double deltaX, double deltaY) {
        this.setPosition(this.position.getX() + deltaX, this.position.getY() + deltaY);
    }

    public void moveTowards(double length, Position towards) {
        Position position = this.getPosition();
        position.moveTowards(length, towards);
        this.setPosition(position);
    }

    public void moveInDirection(double length, double angle) {
        Position position = this.getPosition();
        position.moveInDirection(length, angle);
        this.setPosition(position);
    }

    @Override
    public Position externalToInternalCoordinates(Position externalPosition) {
        Position internal = super.externalToInternalCoordinates(externalPosition);
        internal.add(-this.getPositionX(), -this.getPositionY());
        return internal;
    }

    @Override
    public Position internalToExternalCoordinates(Position internalPosition) {
        Position external = new Position(internalPosition);
        external.add(this.getPositionX(), this.getPositionY());
        return external;
    }

    public String toString() {
        return "position=" + this.position;
    }
}

