/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractSingleColorView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;
import net.useobjects.sync.RunnableWithResult;
import net.useobjects.sync.SyncGui;

public final class LineView
extends AbstractSingleColorView {
    private double length;

    public LineView(GroupView parent, double centerX, double centerY, double angle, Color color, double length) {
        super(centerX, centerY, angle, color);
        this.length = length;
        this.setParent(parent);
    }

    public LineView(double centerX, double centerY, double angle, Color color, double length) {
        this(null, centerX, centerY, angle, color, length);
    }

    public LineView(GroupView parent, double startX, double startY, double endX, double endY, Color color) {
        this(parent, 0.0, 0.0, 0.0, color, 0.0);
        this.setStartEndPositions(startX, startY, endX, endY);
    }

    public LineView(GroupView parent, double startX, double startY, double endX, double endY) {
        this(parent, startX, startY, endX, endY, DEFAULT_COLOR);
    }

    private void setStartEndPositions(double startX, double startY, double endX, double endY) {
        double diffX = endX - startX;
        double diffY = endY - startY;
        super.setPosition(startX + diffX / 2.0, startY + diffY / 2.0);
        Position start = new Position(startX, startY);
        Position end = new Position(endX, endY);
        this.length = Position.distance(start, end);
        this.setRotation(Position.angle(start, end));
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.drawLine((int)(-this.length / 2.0), 0, (int)(this.length / 2.0), 0);
    }

    public double getLength() {
        return SyncGui.invokeAndWait(new RunnableWithResult<Double>(){

            @Override
            public Double runAndReturnResult() {
                return LineView.this.length;
            }
        });
    }

    public Position getStartPosition() {
        return SyncGui.invokeAndWait(new RunnableWithResult<Position>(){

            @Override
            public Position runAndReturnResult() {
                double x = LineView.this.getPositionX() - Math.cos(LineView.this.getRotation()) * LineView.this.length / 2.0;
                double y = LineView.this.getPositionY() - Math.sin(LineView.this.getRotation()) * LineView.this.length / 2.0;
                return new Position(x, y);
            }
        });
    }

    public Position getEndPosition() {
        return SyncGui.invokeAndWait(new RunnableWithResult<Position>(){

            @Override
            public Position runAndReturnResult() {
                double x = LineView.this.getPositionX() + Math.cos(LineView.this.getRotation()) * LineView.this.length / 2.0;
                double y = LineView.this.getPositionY() + Math.sin(LineView.this.getRotation()) * LineView.this.length / 2.0;
                return new Position(x, y);
            }
        });
    }

    public void setStartPosition(final double startX, final double startY) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                LineView.this.setStartEndPositions(startX, startY, LineView.this.getEndPosition().getX(), LineView.this.getEndPosition().getY());
                LineView.this.fireChanged();
            }
        });
    }

    public void setEndPosition(final double endX, final double endY) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                LineView.this.setStartEndPositions(LineView.this.getStartPosition().getX(), LineView.this.getStartPosition().getY(), endX, endY);
                LineView.this.fireChanged();
            }
        });
    }

    public void setStartPosition(Position startPosition) {
        this.setStartPosition(startPosition.getX(), startPosition.getY());
    }

    public void setEndPosition(Position endPosition) {
        this.setEndPosition(endPosition.getX(), endPosition.getY());
    }

    @Override
    public String toString() {
        return super.toString() + ", length=" + this.length;
    }
}

