/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractDrawableMovableObject;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;
import net.useobjects.util.StringFormatter;

public final class DotView
extends AbstractDrawableMovableObject {
    private Color color;

    public DotView(GroupView parent, Position position) {
        this(parent, position.getX(), position.getY());
    }

    public DotView(GroupView parent, Position position, Color color) {
        this(parent, position.getX(), position.getY(), color);
    }

    public DotView(GroupView parent, double positionX, double positionY) {
        this(parent, positionX, positionY, Color.BLACK);
    }

    public DotView(GroupView parent, double positionX, double positionY, Color color) {
        super(positionX, positionY);
        this.color = color;
        this.setParent(parent);
    }

    public DotView(double positionX, double positionY, Color color) {
        this(null, positionX, positionY, color);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.setColor(this.color);
        g2d.drawLine(0, 0, 0, 0);
    }

    @Override
    public String toString() {
        return super.toString() + ", color=" + StringFormatter.toString(this.color);
    }
}

