/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.window;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseButton;
import net.useobjects.mouse.MouseChangedListener;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.mouse.MouseManager;
import net.useobjects.window.MouseEventConventor;
import net.useobjects.window.MouseStatus;
import net.useobjects.window.World2DChangeEvent;
import net.useobjects.window.World2DChangeListener;
import net.useobjects.window.World2DModel;

public class Window2D
extends JPanel
implements World2DChangeListener,
MouseEventSource {
    private World2DModel model;
    private MouseStatus mouseStatus;
    private MouseManager mouseManager;
    MouseEventConventor mouseEventConventor;
    private int[][] gridGaps = new int[][]{{10}, {10}};
    private boolean gridShowed;

    public Window2D(World2DModel model) {
        this.model = model;
        this.setMinimumSize(model.getSize());
        this.setPreferredSize(model.getSize());
        this.setMaximumSize(model.getSize());
        this.setBackground(Color.white);
        model.addWorld2DChangedListener(this);
        this.mouseStatus = new MouseStatus();
        this.addMouseListener(this.mouseStatus);
        this.addMouseMotionListener(this.mouseStatus);
        this.mouseManager = new MouseManager(this);
        this.addMouseListener(this.mouseManager);
        this.addMouseMotionListener(this.mouseManager);
        this.addMouseWheelListener(this.mouseManager);
        model.getRootGroup().setMouseManager(this.mouseManager);
        this.mouseEventConventor = new MouseEventConventor(this);
        this.gridShowed = false;
    }

    @Override
    public void world2DChanged(World2DChangeEvent event) {
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.model.getRootGroup().draw(g2d);
    }

    public boolean isMouseButtonDown(MouseButton mouseButton) {
        return this.mouseStatus.isMouseButtonDown(mouseButton);
    }

    public Position getActualMousePosition() {
        return this.mouseStatus.getMousePosition();
    }

    public MouseManager getMouseManager() {
        return this.mouseManager;
    }

    @Override
    public void addMouseChangedListener(MouseChangedListener listener) {
        this.mouseEventConventor.addMouseChangedListener(listener);
    }

    @Override
    public void removeMouseChangedListener(MouseChangedListener listener) {
        this.mouseEventConventor.removeMouseChangedListener(listener);
    }
}

