/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import net.useobjects.draw.drawable.AbstractSingleColorFillView;
import net.useobjects.draw.drawable.AbstractSingleColorView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;
import net.useobjects.geom.Size;
import net.useobjects.mouse.MouseMediator;
import net.useobjects.sync.SyncGui;

public final class RectangleView
extends AbstractSingleColorFillView {
    private double width;
    private double height;
    private MouseMediator mouseMediator;

    public RectangleView(GroupView parent, double centerX, double centerY, double width, double height, double angle, Color color, boolean fill) {
        super(centerX, centerY, angle, color, fill);
        this.width = width;
        this.height = height;
        this.setParent(parent);
    }

    public RectangleView(GroupView parent, double centerX, double centerY, double width, double height, double angle, Color color) {
        this(parent, centerX, centerY, width, height, angle, color, true);
    }

    public RectangleView(GroupView parent, double centerX, double centerY, double width, double height) {
        this(parent, centerX, centerY, width, height, 0.0, AbstractSingleColorView.DEFAULT_COLOR);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeigh() {
        return this.height;
    }

    public double getHeight() {
        return this.height;
    }

    public void setWidth(final double newWidth) {
        this.throwIfNegative(newWidth, "zaporna sirka");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RectangleView.this.width = newWidth;
                RectangleView.this.fireChanged();
            }
        });
    }

    public void setHeight(final double newHeight) {
        this.throwIfNegative(newHeight, "zaporna vyska");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RectangleView.this.height = newHeight;
                RectangleView.this.fireChanged();
            }
        });
    }

    public void setSize(final double newWidth, final double newHeight) {
        this.throwIfNegative(newWidth, "zaporna sirka");
        this.throwIfNegative(newHeight, "zaporna vyska");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RectangleView.this.width = newWidth;
                RectangleView.this.height = newHeight;
                RectangleView.this.fireChanged();
            }
        });
    }

    public void setSize(Size newSize) {
        this.setSize(newSize.getWidth(), newSize.getHeight());
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        if (this.isFilled()) {
            g2d.fill(this.getRectangle());
        } else {
            g2d.draw(this.getRectangle());
        }
    }

    private Rectangle2D.Double getRectangle() {
        return new Rectangle2D.Double(-this.width / 2.0, -this.height / 2.0, this.width, this.height);
    }

    private Position[] getTransformed() {
        Position[] result = new Position[4];
        return result;
    }

    @Override
    public boolean containsInternal(Position internalPosition) {
        double x = internalPosition.getX();
        double y = internalPosition.getY();
        double w = this.width / 2.0;
        double h = this.height / 2.0;
        return x >= -w && x < w && y >= -h && y < h;
    }

    @Override
    public String toString() {
        return super.toString() + ", size=[" + this.width + " x " + this.height + ']';
    }
}

