/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import net.useobjects.draw.drawable.AbstractSingleColorFillView;
import net.useobjects.draw.drawable.AbstractSingleColorView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;
import net.useobjects.sync.SyncGui;

public final class EllipseView
extends AbstractSingleColorFillView {
    private double radiusX;
    private double radiusY;

    public EllipseView(GroupView parent, double centerX, double centerY, double radiusX, double radiusY, double angle, Color color, boolean fill) {
        super(centerX, centerY, angle, color, fill);
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.setParent(parent);
    }

    public EllipseView(GroupView parent, double centerX, double centerY, double radiusX, double radiusY, double angle, Color color) {
        this(parent, centerX, centerY, radiusX, radiusY, angle, color, true);
    }

    public EllipseView(GroupView parent, double centerX, double centerY, double radiusX, double radiusY) {
        this(parent, centerX, centerY, radiusX, radiusY, 0.0, AbstractSingleColorView.DEFAULT_COLOR);
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        if (this.isFilled()) {
            g2d.fill(this.getEllipse());
        } else {
            g2d.draw(this.getEllipse());
        }
    }

    protected Ellipse2D.Double getEllipse() {
        return new Ellipse2D.Double(-this.radiusX, -this.radiusY, 2.0 * this.radiusX, 2.0 * this.radiusY);
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusX(final double newRadiusX) {
        this.throwIfNegative(newRadiusX, "zaporny polomer v smere osi x");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EllipseView.this.radiusX = newRadiusX;
                EllipseView.this.fireChanged();
            }
        });
    }

    public void setRadiusY(final double newRadiusY) {
        this.throwIfNegative(newRadiusY, "zaporny polomer v smere osi y");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EllipseView.this.radiusY = newRadiusY;
                EllipseView.this.fireChanged();
            }
        });
    }

    public void setRadiuses(final double newRadiusX, final double newRadiusY) {
        this.throwIfNegative(newRadiusX, "zaporny polomer v smere osi x");
        this.throwIfNegative(newRadiusY, "zaporny polomer v smere osi y");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EllipseView.this.radiusX = newRadiusX;
                EllipseView.this.radiusY = newRadiusY;
                EllipseView.this.fireChanged();
            }
        });
    }

    @Override
    public boolean containsInternal(Position internalPosition) {
        double x = internalPosition.getX();
        double y = internalPosition.getY();
        double x2 = x * x;
        double y2 = y * y;
        double rx2 = this.radiusX * this.radiusX;
        double ry2 = this.radiusY * this.radiusY;
        if (rx2 == 0.0 || ry2 == 0.0) {
            return false;
        }
        return x2 / rx2 + y2 / ry2 <= 1.0;
    }

    @Override
    public String toString() {
        return super.toString() + ", radiusX=" + this.radiusX + ", radiusY=" + this.radiusY;
    }
}

