/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.window;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import net.useobjects.mouse.MouseChangedEvent;
import net.useobjects.mouse.MouseChangedListener;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.window.Window2D;

class MouseEventConventor
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Window2D window2D;
    private List<MouseChangedListener> listeners;

    public MouseEventConventor(Window2D window2D) {
        this.window2D = window2D;
        this.listeners = new ArrayList<MouseChangedListener>();
        window2D.addMouseListener(this);
        window2D.addMouseMotionListener(this);
        window2D.addMouseWheelListener(this);
    }

    public void addMouseChangedListener(MouseChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeMouseChangedListener(MouseChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseClicked(newEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMousePressed(newEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseReleased(newEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseEntered(newEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseExited(newEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseDragged(newEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseMoved(newEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        MouseChangedEvent newEvent = new MouseChangedEvent((MouseEventSource)this.window2D, e);
        for (MouseChangedListener listener : this.listeners.toArray(new MouseChangedListener[0])) {
            listener.onMouseWheelMoved(newEvent);
        }
    }
}

