/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractDrawableMovableObject;
import net.useobjects.geom.Position;
import net.useobjects.sync.SyncGui;

public abstract class AbstractDrawableMovableRotatableObject
extends AbstractDrawableMovableObject {
    private double angle;

    public AbstractDrawableMovableRotatableObject(double positionX, double positionY, double angle) {
        super(positionX, positionY);
        this.angle = angle;
    }

    public AbstractDrawableMovableRotatableObject(Position position, double angle) {
        this(position.getX(), position.getY(), angle);
    }

    public AbstractDrawableMovableRotatableObject(double positionX, double positionY) {
        this(positionX, positionY, 0.0);
    }

    public AbstractDrawableMovableRotatableObject(Position position) {
        this(position.getX(), position.getY());
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.rotate(this.getRotation());
    }

    public double getRotation() {
        return this.angle;
    }

    public void setRotation(final double angle) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractDrawableMovableRotatableObject.this.angle = angle;
                AbstractDrawableMovableRotatableObject.this.fireChanged();
            }
        });
    }

    public void addRotation(double deltaAngle) {
        this.setRotation(this.getRotation() + deltaAngle);
    }

    public void move(double length) {
        double diffX = length * Math.cos(this.getRotation() + Math.PI);
        double diffY = length * Math.sin(this.getRotation() + Math.PI);
        this.move(diffX, diffY);
    }

    @Override
    public Position externalToInternalCoordinates(Position externalPosition) {
        Position internal = super.externalToInternalCoordinates(externalPosition);
        double theta = -this.getRotation();
        double x = internal.getX();
        double y = internal.getY();
        double xx = x * Math.cos(theta) - y * Math.sin(theta);
        double yy = x * Math.sin(theta) + y * Math.cos(theta);
        internal.set(xx, yy);
        return internal;
    }

    @Override
    public Position internalToExternalCoordinates(Position internalPosition) {
        double theta = this.getRotation();
        double x = internalPosition.getX();
        double y = internalPosition.getY();
        double xx = x * Math.cos(theta) - y * Math.sin(theta);
        double yy = x * Math.sin(theta) + y * Math.cos(theta);
        Position external = new Position(xx, yy);
        external = super.internalToExternalCoordinates(external);
        return external;
    }

    @Override
    public String toString() {
        return super.toString() + ", rotation=" + this.angle;
    }
}

