/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.geom;

public class Position {
    private double x;
    private double y;

    public Position(Position position) {
        this(position.getX(), position.getY());
    }

    public Position(double x, double y) {
        this.set(x, y);
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getRoundedX() {
        return (int)Math.round(this.x);
    }

    public int getRoundedY() {
        return (int)Math.round(this.y);
    }

    public void add(double deltaX, double deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public void addX(double deltaX) {
        this.x += deltaX;
    }

    public void addY(double deltaY) {
        this.y += deltaY;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public static double distance(Position p1, Position p2) {
        double diffX = p1.getX() - p2.getX();
        double diffY = p1.getY() - p2.getY();
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    public static double angle(Position p1, Position p2) {
        double distance = Position.distance(p1, p2);
        double diffX = p2.getX() - p1.getX();
        double diffY = p2.getY() - p1.getY();
        double angle = Math.asin(diffY / distance);
        if (diffX < 0.0) {
            angle = Math.signum(diffY) * Math.PI - angle;
        }
        return angle;
    }

    public static Position createRandom(int minX, int minY, int maxX, int maxY) {
        int diffX = maxX - minX;
        int diffY = maxY - minY;
        int x = (int)(Math.random() * (double)diffX);
        int y = (int)(Math.random() * (double)diffY);
        return new Position(x + minX, y + minY);
    }

    public boolean isInRectangle(int minX, int minY, int maxX, int maxY) {
        return (double)minX <= this.x && this.x < (double)maxX && (double)minY <= this.y && this.y < (double)maxY;
    }
}

