/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.frame;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.MouseInputListener;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseButton;

class MouseStatus
implements MouseInputListener {
    private Position position = null;
    private Set<MouseButton> buttons = new HashSet<MouseButton>();

    public Position getMousePosition() {
        if (this.position == null) {
            return null;
        }
        return new Position(this.position);
    }

    public boolean isMouseButtonDown(MouseButton mouseButton) {
        return this.buttons.contains((Object)mouseButton);
    }

    private void processMouseMotion(MouseEvent e) {
        if (this.position == null) {
            this.position = new Position(0.0, 0.0);
        }
        Point point = e.getPoint();
        this.position.set(point.x, point.y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.buttons.add(MouseButton.byStandardCode(e.getButton()));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.buttons.remove((Object)MouseButton.byStandardCode(e.getButton()));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.position = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processMouseMotion(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.processMouseMotion(e);
    }
}

