/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import net.useobjects.draw.drawable.AbstractSingleColorFillView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;

public final class CircleView
extends AbstractSingleColorFillView {
    private double radius;

    public CircleView(GroupView parent, Position center, double radius) {
        this(parent, center.getX(), center.getY(), radius, Color.BLACK);
    }

    public CircleView(GroupView parent, Position center, double radius, Color color) {
        this(parent, center.getX(), center.getY(), radius, color);
    }

    public CircleView(GroupView parent, Position center, double radius, Color color, boolean fill) {
        this(parent, center.getX(), center.getY(), radius, color);
    }

    public CircleView(GroupView parent, double centerX, double centerY, double radius) {
        this(parent, centerX, centerY, radius, Color.BLACK);
    }

    public CircleView(GroupView parent, double centerX, double centerY, double radius, Color color) {
        this(parent, centerX, centerY, radius, color, true);
    }

    public CircleView(GroupView parent, double centerX, double centerY, double radius, Color color, boolean fill) {
        super(centerX, centerY, 0.0, color, fill);
        this.radius = radius;
        this.setParent(parent);
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        if (this.isFilled()) {
            g2d.fill(this.getEllipse());
        } else {
            g2d.draw(this.getEllipse());
        }
    }

    protected Ellipse2D.Double getEllipse() {
        return new Ellipse2D.Double(-this.radius, -this.radius, 2.0 * this.radius, 2.0 * this.radius);
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public boolean containsInternal(Position position) {
        double y;
        double x = position.getX();
        return x * x + (y = position.getY()) * y <= this.radius * this.radius;
    }

    @Override
    public String toString() {
        return super.toString() + ", radius=" + this.radius;
    }
}

