/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Graphics2D;
import java.awt.Point;
import net.useobjects.draw.drawable.AbstractDrawableMovableRotatableObject;
import net.useobjects.geom.Position;
import net.useobjects.sync.SyncGui;

public abstract class AbstractDrawableMovableRotatableResizeableObject
extends AbstractDrawableMovableRotatableObject {
    private double resize;

    public AbstractDrawableMovableRotatableResizeableObject(Position position) {
        this(position.getX(), position.getY());
    }

    public AbstractDrawableMovableRotatableResizeableObject(double positionX, double positionY) {
        this(positionX, positionY, 0.0);
    }

    public AbstractDrawableMovableRotatableResizeableObject(Point position, double angle) {
        this(position.getX(), position.getY(), angle);
    }

    public AbstractDrawableMovableRotatableResizeableObject(double positionX, double positionY, double angle) {
        this(positionX, positionY, angle, 1.0);
    }

    public AbstractDrawableMovableRotatableResizeableObject(Position position, double angle, double resizeFactor) {
        this(position.getX(), position.getY(), angle);
        this.resize = resizeFactor;
    }

    public AbstractDrawableMovableRotatableResizeableObject(double positionX, double positionY, double angle, double resizeFactor) {
        super(positionX, positionY, angle);
        this.resize = resizeFactor;
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.scale(this.getResizeFactor(), this.getResizeFactor());
    }

    public void setResizeFactor(final double resizeFactor) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractDrawableMovableRotatableResizeableObject.this.resize = resizeFactor;
                AbstractDrawableMovableRotatableResizeableObject.this.fireChanged();
            }
        });
    }

    public double getResizeFactor() {
        return this.resize;
    }

    @Override
    public Position externalToInternalCoordinates(Position externalPosition) {
        Position internal = super.externalToInternalCoordinates(externalPosition);
        double x = internal.getX() / this.getResizeFactor();
        double y = internal.getY() / this.getResizeFactor();
        internal.set(x, y);
        return internal;
    }

    @Override
    public Position internalToExternalCoordinates(Position internalPosition) {
        double x = internalPosition.getX() * this.getResizeFactor();
        double y = internalPosition.getY() * this.getResizeFactor();
        Position external = new Position(x, y);
        external = super.internalToExternalCoordinates(internalPosition);
        return external;
    }

    @Override
    public String toString() {
        return super.toString() + ", resize=" + this.resize;
    }
}

