/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.window;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import net.useobjects.mouse.MouseChangedEvent;
import net.useobjects.mouse.MouseChangedListener;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.window.Window2D;

class MouseEventConventor
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Window2D window2D;
    private List<MouseChangedListener> listeners;

    public MouseEventConventor(Window2D window2D) {
        this.window2D = window2D;
        this.listeners = new ArrayList<MouseChangedListener>();
        window2D.addMouseListener(this);
        window2D.addMouseMotionListener(this);
        window2D.addMouseWheelListener(this);
    }

    public void addMouseChangedListener(MouseChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeMouseChangedListener(MouseChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseClicked(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMousePressed(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseReleased(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseEntered(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseExited(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseDragged(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseMoved(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        for (MouseChangedListener listener : this.listeners) {
            listener.onMouseWheelMoved(new MouseChangedEvent((MouseEventSource)this.window2D, e));
        }
    }
}

