/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.keyboard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Timer;
import net.useobjects.keyboard.MultiKeyEvent;
import net.useobjects.keyboard.MultiKeyListener;

public class KeyboardForGame
implements KeyListener,
FocusListener {
    private List<MultiKeyListener> listeners = new ArrayList<MultiKeyListener>();
    private Set<Integer> keyCodes = new HashSet<Integer>();
    private Timer timer = new Timer(50, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardForGame.this.sendKeyPressedEvent();
        }
    });

    public KeyboardForGame(Component eventSource) {
        this.timer.setInitialDelay(0);
        eventSource.addKeyListener(this);
        eventSource.addFocusListener(this);
    }

    private void sendKeyPressedEvent() {
        if (!this.keyCodes.isEmpty()) {
            for (MultiKeyListener listener : this.listeners) {
                listener.onKeyPressed(new MultiKeyEvent(this.keyCodes));
            }
        }
    }

    private void sendKeyReleasedEvent(int keyCode) {
        for (MultiKeyListener listener : this.listeners) {
            listener.onKeyReleased(new MultiKeyEvent(new int[]{keyCode}));
        }
    }

    public void addMultiKeyListener(MultiKeyListener listener) {
        this.listeners.add(listener);
    }

    public void removeMultiKeyListener(MultiKeyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyCodes.add(e.getKeyCode());
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyCodes.remove(e.getKeyCode());
        if (this.keyCodes.isEmpty()) {
            this.timer.stop();
        }
        this.sendKeyReleasedEvent(e.getKeyCode());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.timer.stop();
        this.keyCodes.clear();
    }
}

