/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractDrawableMovableRotatableObject;
import net.useobjects.sync.SyncGui;
import net.useobjects.util.FormatString;

public abstract class AbstractSingleColorView
extends AbstractDrawableMovableRotatableObject {
    protected static final Color DEFAULT_COLOR = Color.BLACK;
    private Color foregroundColor;

    public AbstractSingleColorView(double centerX, double centerY, double angle, Color color) {
        super(centerX, centerY, angle);
        this.foregroundColor = color;
    }

    public void setColor(final Color color) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractSingleColorView.this.foregroundColor = color;
                AbstractSingleColorView.this.fireChanged();
            }
        });
    }

    public Color getColor() {
        return new Color(this.foregroundColor.getRGB());
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.setColor(this.foregroundColor);
    }

    @Override
    public String toString() {
        return super.toString() + ", color=" + FormatString.toString(this.foregroundColor);
    }
}

