/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.mouse;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseButton;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.mouse.MouseEventType;

public class MouseChangedEvent {
    private MouseEventSource source;
    private MouseEventType type;
    private double x;
    private double y;
    private int xOnScreen;
    private int yOnScreen;
    private MouseButton button;
    private int wheel;
    private long time;

    public MouseChangedEvent(MouseEventSource source, MouseEventType type, double x, double y, int xOnScreen, int yOnScreen, MouseButton button, int wheel, long time) {
        this.source = source;
        this.type = type;
        this.x = x;
        this.y = y;
        this.xOnScreen = xOnScreen;
        this.yOnScreen = yOnScreen;
        this.button = button;
        this.wheel = wheel;
        this.time = time;
    }

    public MouseChangedEvent(MouseEventSource newSource, MouseEvent event) {
        this(newSource, MouseEventType.byStandardType(event.getID()), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), MouseButton.byStandardCode(event.getButton()), 0, event.getWhen());
    }

    public MouseChangedEvent(MouseEventSource newSource, MouseWheelEvent event) {
        this(newSource, MouseEventType.byStandardType(event.getID()), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), MouseButton.byStandardCode(event.getButton()), event.getWheelRotation(), event.getWhen());
    }

    public MouseEventSource getSource() {
        return this.source;
    }

    public MouseEventType getType() {
        return this.type;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Position getPosition() {
        return new Position(this.x, this.y);
    }

    public MouseButton getButton() {
        return this.button;
    }

    public int getWheel() {
        return this.wheel;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return "type=" + (Object)((Object)this.type) + ", x=" + this.x + ", y=" + this.y + ", button=" + (Object)((Object)this.button) + ", wheel=" + this.wheel + ", time=" + this.time;
    }
}

