/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.useobjects.draw.drawable.AbstractDrawableMovableRotatableObject;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.draw.event.DrawableChangeEvent;
import net.useobjects.draw.event.DrawableChangeListener;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.mouse.MouseManager;
import net.useobjects.mouse.MouseMediator;
import net.useobjects.sync.RunAndReturnResult;
import net.useobjects.sync.SyncGui;

public class GroupView
extends AbstractDrawableMovableRotatableObject
implements DrawableChangeListener,
Iterable<AbstractDrawableObject>,
MouseEventSource {
    private List<AbstractDrawableObject> items = new ArrayList<AbstractDrawableObject>();
    private MouseMediator mouseMediator;

    public GroupView(GroupView parent, Position position) {
        this(parent, position.getX(), position.getY());
    }

    public GroupView(GroupView parent, double positionX, double positionY) {
        this(parent, positionX, positionY, 0.0);
    }

    public GroupView(GroupView parent, Position position, double angle) {
        this(parent, position.getX(), position.getY(), angle);
    }

    public GroupView(GroupView parent, double positionX, double positionY, double angle) {
        super(positionX, positionY, angle);
        this.setParent(parent);
    }

    public void add(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GroupView.this.items.add(drawable);
                drawable.setParent(GroupView.this);
                drawable.addDrawableChangeListener(GroupView.this);
                if (drawable instanceof MouseEventSource) {
                    ((MouseEventSource)((Object)drawable)).setMouseManager(GroupView.this.getMouseManager());
                }
                GroupView.this.fireChanged();
            }
        });
    }

    public void remove(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GroupView.this.items.remove(drawable);
                drawable.removeDrawableChangeListener(GroupView.this);
                if (drawable.getParent() == GroupView.this) {
                    drawable.setParent(null);
                }
                if (drawable instanceof MouseEventSource) {
                    ((MouseEventSource)((Object)drawable)).setMouseManager(null);
                }
                GroupView.this.fireChanged();
            }
        });
    }

    public void removeAll() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                while (!GroupView.this.items.isEmpty()) {
                    GroupView.this.remove((AbstractDrawableObject)GroupView.this.items.get(0));
                }
            }
        });
    }

    public boolean contains(final AbstractDrawableObject drawable) {
        return SyncGui.invokeAndWait(new RunAndReturnResult<Boolean>(){

            @Override
            public Boolean runAndReturnResult() {
                for (AbstractDrawableObject d : GroupView.this.items) {
                    if (d != drawable) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void drawableChanged(DrawableChangeEvent event) {
        this.fireChanged();
    }

    @Override
    public Iterator<AbstractDrawableObject> iterator() {
        return this.items.iterator();
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        for (AbstractDrawableObject item : this.items) {
            Graphics2D copy = (Graphics2D)g2d.create();
            item.draw(copy);
        }
    }

    private MouseMediator getMouseMediator() {
        if (this.mouseMediator == null) {
            this.mouseMediator = new MouseMediator(this);
        }
        return this.mouseMediator;
    }

    @Override
    public void setMouseManager(MouseManager manager) {
        this.getMouseMediator().setMouseManager(manager);
        for (AbstractDrawableObject drawable : this.items) {
            if (!(drawable instanceof MouseEventSource)) continue;
            ((MouseEventSource)((Object)drawable)).setMouseManager(manager);
        }
    }

    private MouseManager getMouseManager() {
        return this.getMouseMediator().getMouseManager();
    }

    @Override
    public boolean containsInternal(Position position) {
        for (AbstractDrawableObject drawable : this.items) {
            Position pos;
            if (!(drawable instanceof MouseEventSource) || !(drawable instanceof AbstractDrawableObject) || !((MouseEventSource)((Object)drawable)).containsInternal(pos = drawable.externalToInternalCoordinates(position))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.getMouseMediator().addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.getMouseMediator().removeMouseListener(listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        this.getMouseMediator().addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.getMouseMediator().removeMotionListener(listener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener listener) {
        this.getMouseMediator().addMouseWheelListener(listener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.getMouseMediator().removeWheelListener(listener);
    }

    @Override
    public String toString() {
        String res = "[";
        for (AbstractDrawableObject drawable : this.items) {
            res = res + drawable.toString();
            res = res + ", ";
        }
        res = res.replaceAll(", $", "");
        res = res + "]";
        return res;
    }
}

