/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.keyboard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;

public class KeyboardConstantRate
implements KeyListener,
FocusListener {
    private List<KeyListener> listeners = new LinkedList<KeyListener>();
    private Map<Integer, KeyPressedTask> tasks = new HashMap<Integer, KeyPressedTask>();

    public KeyboardConstantRate(Component eventSource) {
        eventSource.addKeyListener(this);
        eventSource.addFocusListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        for (KeyListener listener : this.listeners) {
            listener.keyTyped(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.tasks.containsKey(e.getKeyCode())) {
            this.tasks.put(e.getKeyCode(), new KeyPressedTask(e));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.tasks.containsKey(keyCode)) {
            this.tasks.get(keyCode).stop();
            this.tasks.remove(keyCode);
        }
        for (KeyListener listener : this.listeners) {
            listener.keyReleased(e);
        }
    }

    public boolean isKeyDown(int keyCode) {
        return this.tasks.containsKey(keyCode);
    }

    public void addKeyListener(KeyListener listener) {
        this.listeners.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Set<Integer> keySet = this.tasks.keySet();
        for (int key : keySet) {
            this.tasks.get(key).stop();
        }
        this.tasks.clear();
    }

    private class KeyPressedTask
    implements ActionListener {
        private static final int DELAY = 50;
        private Timer timer;
        private KeyEvent event;

        public KeyPressedTask(KeyEvent event) {
            this.event = event;
            this.sendKeyPressedEvent();
            this.timer = new Timer(50, this);
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sendKeyPressedEvent();
        }

        public void sendKeyPressedEvent() {
            for (KeyListener listener : KeyboardConstantRate.this.listeners) {
                listener.keyPressed(this.event);
            }
        }
    }
}

