/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.frame.MouseStatus;
import net.useobjects.frame.attributelabel.AttributeMousePositionLabel;
import net.useobjects.frame.attributelabel.AttributeSizeLabel;
import net.useobjects.geom.Position;
import net.useobjects.keyboard.Keyboard;
import net.useobjects.keyboard.KeyboardConstantRate;
import net.useobjects.mouse.MouseButton;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.mouse.MouseManager;
import net.useobjects.sync.RunAndReturnResult;
import net.useobjects.sync.SyncGui;
import net.useobjects.window.Window2D;
import net.useobjects.world.World2DModel;

public class MainWindow {
    private JFrame frame;
    private World2DModel model;
    private Window2D window;
    private Keyboard keyboard;
    private KeyboardConstantRate keyboardConstantRate;
    private MouseManager mouseManager;
    private MouseStatus mouseStatus;

    public MainWindow(String title) {
        this(title, 0, 0);
    }

    public MainWindow(final String title, final int width, final int height) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.frame = new JFrame(title);
                MainWindow.this.frame.setDefaultCloseOperation(3);
                MainWindow.this.frame.setResizable(false);
                MainWindow.this.model = new World2DModel(width, height);
                MainWindow.this.window = new Window2D(MainWindow.this.model);
                MainWindow.this.frame.setLayout(new BorderLayout());
                MainWindow.this.frame.add((Component)MainWindow.this.window, "Center");
                JPanel statusPanel = new JPanel(new FlowLayout(0, 0, 0));
                MainWindow.this.frame.add((Component)statusPanel, "South");
                AttributeSizeLabel sizeLabel = new AttributeSizeLabel("size");
                MainWindow.this.window.addComponentListener(sizeLabel);
                statusPanel.add(sizeLabel);
                AttributeMousePositionLabel positionLabel = new AttributeMousePositionLabel("position");
                MainWindow.this.window.addMouseListener(positionLabel);
                MainWindow.this.window.addMouseMotionListener(positionLabel);
                statusPanel.add(positionLabel);
                MainWindow.this.keyboard = new Keyboard(MainWindow.this.frame);
                MainWindow.this.keyboardConstantRate = new KeyboardConstantRate(MainWindow.this.frame);
                MainWindow.this.mouseStatus = new MouseStatus();
                MainWindow.this.window.addMouseListener(MainWindow.this.mouseStatus);
                MainWindow.this.window.addMouseMotionListener(MainWindow.this.mouseStatus);
                MainWindow.this.mouseManager = new MouseManager(MainWindow.this.window);
                MainWindow.this.window.addMouseListener(MainWindow.this.mouseManager);
                MainWindow.this.window.addMouseMotionListener(MainWindow.this.mouseManager);
                MainWindow.this.window.addMouseWheelListener(MainWindow.this.mouseManager);
                MainWindow.this.frame.pack();
            }
        });
    }

    public void setVisible(final boolean b) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.frame.setVisible(b);
            }
        });
    }

    public void add(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.model.add(drawable);
                if (drawable instanceof MouseEventSource) {
                    MouseEventSource source = (MouseEventSource)((Object)drawable);
                    source.setMouseManager(MainWindow.this.mouseManager);
                }
            }
        });
    }

    public void remove(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.model.remove(drawable);
                if (drawable instanceof MouseEventSource) {
                    MouseEventSource source = (MouseEventSource)((Object)drawable);
                    source.setMouseManager(null);
                }
            }
        });
    }

    public GroupView getRootGroup() {
        return SyncGui.invokeAndWait(new RunAndReturnResult<GroupView>(){

            @Override
            public GroupView runAndReturnResult() {
                return MainWindow.this.model.getRootGroup();
            }
        });
    }

    public void dispose() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.frame.dispose();
            }
        });
    }

    public int getInternalWidth() {
        return this.model.getWidth();
    }

    public int getInternalHeight() {
        return this.model.getHeight();
    }

    public void setBackground(Color color) {
        this.window.setBackground(color);
    }

    public boolean isKeyDown(int keyCode) {
        return this.keyboard.isKeyDown(keyCode);
    }

    public boolean isMouseButtonDown(MouseButton mouseButton) {
        return this.mouseStatus.isMouseButtonDown(mouseButton);
    }

    public Position getMousePosition() {
        return this.mouseStatus.getMousePosition();
    }

    public void addKeyListener(KeyListener listener) {
        this.frame.addKeyListener(listener);
    }

    public void remvoeKeyListener(KeyListener listener) {
        this.frame.removeKeyListener(listener);
    }

    public void addConstantRateKeyListener(KeyListener listener) {
        this.keyboardConstantRate.addKeyListener(listener);
    }

    public void remvoeConstantRateKeyListener(KeyListener listener) {
        this.keyboardConstantRate.removeKeyListener(listener);
    }

    public synchronized void addMouseListener(final MouseListener listener) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.window.addMouseListener(listener);
            }
        });
    }

    public synchronized void removeMouseListener(final MouseListener listener) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.window.removeMouseListener(listener);
            }
        });
    }

    public synchronized void addMouseMotionListener(final MouseMotionListener listener) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.window.addMouseMotionListener(listener);
            }
        });
    }

    public synchronized void removeMouseMotionListener(final MouseMotionListener listener) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.window.removeMouseMotionListener(listener);
            }
        });
    }

    public synchronized void addMouseWheelListener(final MouseWheelListener listener) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.window.addMouseWheelListener(listener);
            }
        });
    }

    public synchronized void removeMouseWheelListener(final MouseWheelListener listener) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.window.removeMouseWheelListener(listener);
            }
        });
    }
}

