/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.mouse;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.mouse.MouseManager;

public class MouseMediator {
    private MouseEventSource view;
    private MouseManager manager;
    private List<MouseListener> listenersList;
    private List<MouseMotionListener> motionListenersList;
    private List<MouseWheelListener> wheelListenersList;
    private boolean mouseInside;

    public MouseMediator(MouseEventSource view) {
        this.view = view;
        this.listenersList = new ArrayList<MouseListener>();
        this.motionListenersList = new ArrayList<MouseMotionListener>();
        this.wheelListenersList = new ArrayList<MouseWheelListener>();
    }

    public void setMouseManager(MouseManager manager) {
        if (this.manager != manager) {
            if (this.manager != null) {
                this.manager.removeMouseMediator(this);
            }
            this.manager = manager;
            if (!(this.manager == null || this.listenersList.isEmpty() && this.motionListenersList.isEmpty() && this.wheelListenersList.isEmpty())) {
                manager.addMouseMediator(this);
                this.mouseInside = this.IsMouseInside();
            }
        }
    }

    public MouseManager getMouseManager() {
        return this.manager;
    }

    public void addMouseListener(MouseListener listener) {
        this.listenersList.add(listener);
        if (this.manager != null && !this.manager.containMouseMediator(this)) {
            this.manager.addMouseMediator(this);
            this.mouseInside = this.IsMouseInside();
        }
    }

    public void removeMouseListener(MouseListener listener) {
        this.listenersList.remove(listener);
        if (this.listenersList.isEmpty() && this.motionListenersList.isEmpty() && this.wheelListenersList.isEmpty() && this.manager != null) {
            this.manager.removeMouseMediator(this);
        }
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.motionListenersList.add(listener);
        if (this.manager != null && !this.manager.containMouseMediator(this)) {
            this.manager.addMouseMediator(this);
        }
    }

    public void removeMotionListener(MouseMotionListener listener) {
        this.motionListenersList.remove(listener);
        if (this.listenersList.isEmpty() && this.motionListenersList.isEmpty() && this.wheelListenersList.isEmpty() && this.manager != null) {
            this.manager.removeMouseMediator(this);
        }
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.wheelListenersList.add(listener);
        if (this.manager != null && !this.manager.containMouseMediator(this)) {
            this.manager.addMouseMediator(this);
        }
    }

    public void removeWheelListener(MouseWheelListener listener) {
        this.wheelListenersList.remove(listener);
        if (this.listenersList.isEmpty() && this.motionListenersList.isEmpty() && this.wheelListenersList.isEmpty() && this.manager != null) {
            this.manager.removeMouseMediator(this);
        }
    }

    private boolean IsMouseInside() {
        Point mousePosition = this.manager.getWindow().getMousePosition();
        if (mousePosition == null) {
            return false;
        }
        return this.isInInternal(mousePosition.x, mousePosition.y);
    }

    private Position globalToInternal(int x, int y) {
        return ((AbstractDrawableObject)((Object)this.view)).globalToInternalCoordinates(new Position(x, y));
    }

    private boolean isInInternal(int x, int y) {
        Position internal = this.globalToInternal(x, y);
        return this.view.containsInternal(internal);
    }

    private MouseEvent createInternalMouseEvent(MouseEvent original, int x, int y) {
        return new MouseEvent(original.getComponent(), original.getID(), original.getWhen(), original.getModifiersEx(), x, y, original.getXOnScreen(), original.getYOnScreen(), original.getClickCount(), original.isPopupTrigger(), original.getButton());
    }

    private MouseEvent createMouseEventAndChangeType(MouseEvent original, int type) {
        return new MouseEvent(original.getComponent(), type, original.getWhen(), original.getModifiersEx(), original.getX(), original.getY(), original.getXOnScreen(), original.getYOnScreen(), original.getClickCount(), original.isPopupTrigger(), original.getButton());
    }

    private MouseWheelEvent createInternalMouseWhellEvent(MouseWheelEvent original, int x, int y) {
        return new MouseWheelEvent(original.getComponent(), original.getID(), original.getWhen(), original.getModifiersEx(), x, y, original.getXOnScreen(), original.getYOnScreen(), original.getClickCount(), original.isPopupTrigger(), original.getScrollType(), original.getScrollAmount(), original.getWheelRotation(), original.getPreciseWheelRotation());
    }

    private MouseEvent check(MouseEvent mouseEvent) {
        Position internalPosition = this.globalToInternal(mouseEvent.getX(), mouseEvent.getY());
        if (this.view.containsInternal(internalPosition)) {
            return this.createInternalMouseEvent(mouseEvent, internalPosition.getRoundedX(), internalPosition.getRoundedY());
        }
        return null;
    }

    private <T> void fire(List<T> list, MouseEvent e, Firing<T> f) {
        MouseEvent newEvent;
        if (!list.isEmpty() && (newEvent = this.check(e)) != null) {
            for (T listener : list) {
                f.execute(listener, newEvent);
            }
        }
    }

    public void fireMouseClicked(MouseEvent e) {
        this.fire(this.listenersList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.mouseClicked(newEvent);
            }
        });
    }

    public void fireMousePressed(MouseEvent e) {
        this.fire(this.listenersList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.mousePressed(newEvent);
            }
        });
    }

    public void fireMouseReleased(MouseEvent e) {
        this.fire(this.listenersList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.mouseReleased(newEvent);
            }
        });
    }

    private void fireMouseEntered(MouseEvent e) {
        this.fire(this.listenersList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.mouseEntered(newEvent);
            }
        });
    }

    private void fireMouseExited(MouseEvent e) {
        if (!this.listenersList.isEmpty()) {
            Position internal = this.globalToInternal(e.getX(), e.getY());
            MouseEvent newEvent = this.createInternalMouseEvent(e, internal.getRoundedX(), internal.getRoundedY());
            for (MouseListener listener : this.listenersList) {
                listener.mouseExited(newEvent);
            }
        }
    }

    public void fireEnteredExited(MouseEvent e) {
        boolean isIn = this.isInInternal(e.getX(), e.getY());
        if (e.getID() == 505) {
            isIn = false;
        }
        if (this.mouseInside != isIn) {
            if (isIn) {
                this.fireMouseEntered(this.createMouseEventAndChangeType(e, 504));
            } else {
                this.fireMouseExited(this.createMouseEventAndChangeType(e, 505));
            }
            this.mouseInside = isIn;
        }
    }

    public void fireMouseDragged(MouseEvent e) {
        this.fire(this.motionListenersList, e, new Firing<MouseMotionListener>(){

            @Override
            public void execute(MouseMotionListener listener, MouseEvent newEvent) {
                listener.mouseDragged(newEvent);
            }
        });
    }

    public void fireMouseMoved(MouseEvent e) {
        this.fire(this.motionListenersList, e, new Firing<MouseMotionListener>(){

            @Override
            public void execute(MouseMotionListener listener, MouseEvent newEvent) {
                listener.mouseMoved(newEvent);
            }
        });
    }

    public void fireMouseWheelMoved(MouseWheelEvent e) {
        if (!this.wheelListenersList.isEmpty()) {
            MouseEvent newEvent = this.check(e);
            Position internal = this.globalToInternal(e.getX(), e.getY());
            if (this.view.containsInternal(internal)) {
                this.createInternalMouseWhellEvent(e, internal.getRoundedX(), internal.getRoundedY());
                for (MouseWheelListener item : this.wheelListenersList) {
                    item.mouseWheelMoved(e);
                }
            }
        }
    }

    private static interface Firing<T> {
        public void execute(T var1, MouseEvent var2);
    }
}

