/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractSingleColorView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;
import net.useobjects.sync.RunAndReturnResult;
import net.useobjects.sync.SyncGui;

public final class LineView
extends AbstractSingleColorView {
    private double length;
    private Position start;
    private Position end;

    public LineView(GroupView parent, double centerX, double centerY, double angle, Color color, double length) {
        super(centerX, centerY, angle, color);
        this.length = length;
        this.setParent(parent);
    }

    public LineView(GroupView parent, double startX, double startY, double endX, double endY, Color color) {
        this(parent, 0.0, 0.0, 0.0, color, 0.0);
        this.setImpl(startX, startY, endX, endY);
    }

    private void setImpl(double startX, double startY, double endX, double endY) {
        this.start = new Position(startX, startY);
        this.end = new Position(endX, endY);
        double diffX = endX - startX;
        double diffY = endY - startY;
        this.setPosition(startX + diffX / 2.0, startY + diffY / 2.0);
        this.length = Position.distance(this.start, this.end);
        this.setRotation(Position.angle(this.start, this.end));
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.drawLine((int)(-this.length / 2.0), 0, (int)(this.length / 2.0), 0);
    }

    public double getLength() {
        return SyncGui.invokeAndWait(new RunAndReturnResult<Double>(){

            @Override
            public Double runAndReturnResult() {
                return LineView.this.length;
            }
        });
    }

    public Position getStartPosition() {
        return SyncGui.invokeAndWait(new RunAndReturnResult<Position>(){

            @Override
            public Position runAndReturnResult() {
                return new Position(LineView.this.start);
            }
        });
    }

    public Position getEndPosition() {
        return SyncGui.invokeAndWait(new RunAndReturnResult<Position>(){

            @Override
            public Position runAndReturnResult() {
                return new Position(LineView.this.end);
            }
        });
    }

    public void setStartPosition(final double startX, final double startY) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                LineView.this.setImpl(startX, startY, LineView.this.end.getX(), LineView.this.end.getY());
                LineView.this.fireChanged();
            }
        });
    }

    public void setEndPosition(final double endX, final double endY) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                LineView.this.setImpl(LineView.this.start.getX(), LineView.this.start.getY(), endX, endY);
                LineView.this.fireChanged();
            }
        });
    }

    @Override
    public String toString() {
        return super.toString() + ", legth=" + this.length;
    }
}

