/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.draw.event.DrawableChangeEvent;
import net.useobjects.draw.event.DrawableChangeListener;
import net.useobjects.geom.Position;

public abstract class AbstractDrawableObject {
    private GroupView parent = null;
    private Set<DrawableChangeListener> changeListeners = new HashSet<DrawableChangeListener>();

    @PostConstruct
    public void init() {
        System.out.println("init");
    }

    public abstract void draw(Graphics2D var1);

    public void addDrawableChangeListener(DrawableChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeDrawableChangeListener(DrawableChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireChanged() {
        for (DrawableChangeListener listener : this.changeListeners) {
            listener.drawableChanged(new DrawableChangeEvent());
        }
    }

    protected GroupView getParent() {
        return this.parent;
    }

    protected final void setParent(GroupView parent) {
        if (this.parent != parent) {
            if (this.parent != null && this.parent.contains(this)) {
                this.parent.remove(this);
            }
            this.parent = parent;
            if (this.parent != null && !this.parent.contains(this)) {
                this.parent.add(this);
            }
        }
    }

    public Position externalToInternalCoordinates(Position externalPosition) {
        return new Position(externalPosition);
    }

    public Position internalToExternalCoordinates(Position internalPosition) {
        return new Position(internalPosition);
    }

    public Position internalToGlobalCoordinates(Position internalPosition) {
        Position position = this.internalToExternalCoordinates(internalPosition);
        if (this.getParent() != null) {
            return this.getParent().internalToGlobalCoordinates(position);
        }
        return position;
    }

    public Position globalToInternalCoordinates(Position globalPosition) {
        Position position = null;
        position = this.getParent() != null ? this.getParent().globalToInternalCoordinates(globalPosition) : globalPosition;
        return this.externalToInternalCoordinates(position);
    }
}

