/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.draw.drawable.AbstractSingleColorFillView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.geom.Position;

public class PolygonView
extends AbstractSingleColorFillView {
    private int[] xPoints;
    private int[] yPoints;

    public PolygonView(GroupView parent, double centerX, double centerY, int ... points) {
        this(parent, centerX, centerY, Color.BLACK, true, points);
    }

    public PolygonView(GroupView parent, double centerX, double centerY, Color color, boolean fill, int ... points) {
        super(centerX, centerY, 0.0, color, fill);
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("neparny pocet suradnic x a y");
        }
        if (points.length < 6) {
            throw new IllegalArgumentException("polygon musi mat minimalne 3 vrcholy");
        }
        int max = points.length - points.length % 2;
        int num = max / 2;
        this.xPoints = new int[max / 2];
        this.yPoints = new int[max / 2];
        for (int i = 0; i < max; i += 2) {
            int j = i / 2;
            this.xPoints[j] = points[i];
            this.yPoints[j] = points[i + 1];
        }
        this.setParent(parent);
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        if (this.isFilled()) {
            g2d.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
        } else {
            g2d.drawPolygon(this.xPoints, this.yPoints, this.xPoints.length);
        }
    }

    @Override
    public boolean containsInternal(Position position) {
        if (!this.isConvex()) {
            throw new UnsupportedOperationException("udalosti mysi moze polygon generovat iba ak je konvexny (vsetky vnutorne uhly mensia alebo rovne 180 stupnov");
        }
        double posX = position.getX();
        double posY = position.getY();
        int sig = this.signumForConvex();
        for (int i1 = 0; i1 < this.xPoints.length; ++i1) {
            int i2 = (i1 + 1) % this.xPoints.length;
            int yDiff = this.yPoints[i2] - this.yPoints[i1];
            double xx = posX - (double)this.xPoints[i2];
            int xDiff = this.xPoints[i2] - this.xPoints[i1];
            double yy = posY - (double)this.yPoints[i2];
            double cosAngleProportion = (double)yDiff * xx - (double)xDiff * yy;
            if (cosAngleProportion == 0.0 || (double)sig == Math.signum(cosAngleProportion)) continue;
            return false;
        }
        return true;
    }

    private int signumForConvex() {
        for (int i1 = 0; i1 < this.xPoints.length; ++i1) {
            int i2 = (i1 + 1) % this.xPoints.length;
            int yDiff = this.yPoints[i2] - this.yPoints[i1];
            int i3 = (i1 + 2) % this.xPoints.length;
            int xx = this.xPoints[i3] - this.xPoints[i2];
            int xDiff = this.xPoints[i2] - this.xPoints[i1];
            int yy = this.yPoints[i3] - this.yPoints[i2];
            int cosAngleProportion = yDiff * xx - xDiff * yy;
            if (cosAngleProportion == 0) continue;
            return (int)Math.signum(cosAngleProportion);
        }
        return 0;
    }

    private boolean isConvex() {
        int lastSignum = 0;
        for (int i1 = 0; i1 < this.xPoints.length; ++i1) {
            int i2 = (i1 + 1) % this.xPoints.length;
            int yDiff = this.yPoints[i2] - this.yPoints[i1];
            int i3 = (i1 + 2) % this.xPoints.length;
            int xx = this.xPoints[i3] - this.xPoints[i2];
            int xDiff = this.xPoints[i2] - this.xPoints[i1];
            int yy = this.yPoints[i3] - this.yPoints[i2];
            int cosAngleProportion = yDiff * xx - xDiff * yy;
            if (cosAngleProportion == 0) continue;
            int signumCosAngleProportion = (int)Math.signum(cosAngleProportion);
            if (i1 > 0 && lastSignum != signumCosAngleProportion) {
                return false;
            }
            lastSignum = signumCosAngleProportion;
        }
        return true;
    }

    @Override
    public String toString() {
        String result = super.toString() + ", points=[";
        for (int i = 0; i < this.xPoints.length; ++i) {
            result = result + "[" + this.xPoints[i] + "," + this.yPoints[i] + "], ";
        }
        result = result.replaceAll(", $", "") + "]";
        return result;
    }
}

